package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.param.talent.TalentListQueryParam;
import com.bxm.localnews.admin.param.talent.UpgradeTalentParam;
import com.bxm.localnews.admin.service.base.TalentMangeService;
import com.bxm.localnews.admin.vo.talent.TalentListVO;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * @author wzy
 * @version 1.0
 * @date 2020/12/10 2:11 下午
 */
@RestController
@Api(tags = "1-64 [管理]后台用户达人管理接口", description = "后台用户达人管理接口")
@RequestMapping("api/admin/talent")
public class TalentManageController {

    private final TalentMangeService talentMangeService;

    public TalentManageController(TalentMangeService talentMangeService) {
        this.talentMangeService = talentMangeService;
    }

    @ApiOperation(value = "1-64-1 根据条件查询达人关系列表", notes = "根据条件查询达人关系列表")
    @GetMapping("/getTalentList")
    public ResponseJson<PageWarper<TalentListVO>> getTalentList(TalentListQueryParam param) {
        return ResponseJson.ok(talentMangeService.getTalentList(param));
    }

    @ApiOperation(value = "1-64-2 升级达人等级", notes = "升级达人等级")
    @PostMapping("/upgradeTalent")
    public ResponseJson upgradeTalent(@RequestBody UpgradeTalentParam param) {
        Message result = talentMangeService.upgradeTalent(param);
        if (Boolean.FALSE.equals(result.isSuccess())) {
            return ResponseJson.badReqeuset(result.getLastMessage()).build();
        }
        return ResponseJson.ok().build();
    }
}