package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.dto.ChannelInfoDetailDTO;
import com.bxm.localnews.admin.dto.UserChannelDTO;
import com.bxm.localnews.admin.param.UserChannelParam;
import com.bxm.localnews.admin.service.base.UserChannelService;
import com.bxm.localnews.admin.vo.LocationChannelBean;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.List;


@Api(tags = "1-62 [管理]栏目管理", description = "用户栏目管理")
@RestController
@RequestMapping("api/admin/userChannel")
public class UserChannelController {

    private final UserChannelService userChannelService;

    public UserChannelController(UserChannelService userChannelService) {
        this.userChannelService = userChannelService;
    }

    @ApiOperation(value = "1-62-01 栏目列表", notes = "栏目列表")
    @GetMapping("/getList")
    public ResponseJson<PageWarper<UserChannelDTO>> getList(UserChannelParam userChannelParam) {
        return ResponseJson.ok(userChannelService.getList(userChannelParam));
    }

    @ApiOperation(value = "1-62-02 栏目详情", notes = "栏目详情")
    @GetMapping("/getDetail")
    @ApiImplicitParam(name = "channelId", value = "栏目id", required = true)
    public ResponseJson<ChannelInfoDetailDTO> getDetail(@ApiIgnore UserChannelParam userChannelParam) {
        return ResponseJson.ok(userChannelService.getDetail(userChannelParam));
    }

    @ApiOperation(value = "1-62-03 新增栏目", notes = "新增栏目")
    @PostMapping("/insert")
    public ResponseJson<Boolean> insert(@RequestBody ChannelInfoDetailDTO channelInfoDetailDTO) {
        return ResponseJson.ok(userChannelService.insert(channelInfoDetailDTO));
    }

    @ApiOperation(value = "1-62-04 修改栏目", notes = "修改栏目")
    @PostMapping("/update")
    public ResponseJson<Boolean> update(@RequestBody ChannelInfoDetailDTO channelInfoDetailDTO) {
        return ResponseJson.ok(userChannelService.update(channelInfoDetailDTO));
    }

    @ApiOperation(value = "1-62-05 修改栏目状态：上架或下架", notes = "修改栏目状态：上架或下架")
    @GetMapping("/delete")
    @ApiImplicitParam(name = "channelId", value = "栏目id", required = true)
    public ResponseJson<Boolean> updateStatus(@ApiIgnore UserChannelParam userChannelParam) {
        return ResponseJson.ok(userChannelService.updateStatus(userChannelParam));
    }

    @ApiOperation(value = "1-62-06 获取可用的栏目列表")
    @GetMapping("/enable/list")
    public ResponseJson<List<LocationChannelBean>> getEnableList() {
        return ResponseJson.ok(userChannelService.getEnableList());
    }
}
