package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.service.base.UserCommonTagService;
import com.bxm.localnews.admin.vo.UserCommonTag;
import com.bxm.localnews.common.vo.Json;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;


@Api(tags = "1-58 [管理]用户标签", description = "用户标签")
@RestController
@RequestMapping("api/admin/userCommonTag")
public class UserCommonTagController {

    private final UserCommonTagService userCommonTagService;

    @Autowired
    public UserCommonTagController(UserCommonTagService userCommonTagService) {
        this.userCommonTagService = userCommonTagService;
    }

    @ApiOperation(value = "1-58-1 用户标签列表查询", notes = "用户标签列表查询")
    @GetMapping("")
    public Json<List<UserCommonTag>> listTags() {
        return Json.ok(new ArrayList<>(userCommonTagService.getUserCommonTagMap().values()));
    }
}
