package com.bxm.localnews.admin.controller.market;

import com.bxm.localnews.admin.common.MarketProperties;
import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.param.MarketCommodityQueryParam;
import com.bxm.localnews.admin.service.market.MarketCommodityService;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.admin.vo.MarketCommodity;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.math.BigDecimal;

@Api(tags = "1-50 [管理]商品管理", description = "积分商城商品管理")
@RestController
@RequestMapping("api/admin/marketCommodity")
public class MarketCommodityController extends CommonController {

    @Resource
    private MarketCommodityService marketCommodityService;

    @Resource
    private MarketProperties marketProperties;

    @ApiOperation(value = "1-50-1 获取商品列表")
    @GetMapping("list")
    public Json<PageWarper<MarketCommodity>> getList(MarketCommodityQueryParam param) {
        return ResultUtil.genSuccessResult(marketCommodityService.getList(param));
    }

    @ApiOperation(value = "1-50-2 获取商品详情")
    @GetMapping("detail")
    public Json<MarketCommodity> getMarketCommodityById(Long id) {
        return ResultUtil.genSuccessResult(marketCommodityService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-50-3 商品上下架")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "商品id", required = true),
            @ApiImplicitParam(name = "status", value = "状态：0下架 1上架", required = true)
    })
    @PostMapping("updateStatus")
    public Json updateStatusById(Long id, Byte status) {
        return ResultUtil.genSuccessResult(marketCommodityService.updateStatus(id, status));
    }

    @ApiOperation(value = "1-50-4 新增或编辑商品")
    @PostMapping("saveOrUpdate")
    public Json saveOrUpdate(@RequestBody MarketCommodity marketCommodity) {
        return ResultUtil.genSuccessResult(marketCommodityService.saveOrUpdate(marketCommodity));
    }

    @ApiOperation(value = "1-50-5 修改商品权重")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "商品id", required = true),
            @ApiImplicitParam(name = "order", value = "权重", required = true)
    })
    @PostMapping("updateOrder")
    public Json updateOrderById(Long id, Integer order) {
        return ResultUtil.genSuccessResult(marketCommodityService.updateOrder(id, order));
    }

    @ApiOperation(value = "1-50-6 删除商品")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "商品id", required = true)
    })
    @PostMapping("delete")
    public Json deleteById(Long id) {
        AdminUser user = getLoginUser();
        if (null == user) {
            return ResultUtil.genFailedResult("当前无登录用户");
        }
        return ResultUtil.genSuccessResult(marketCommodityService.deleteById(id, user.getId()));
    }

    @ApiOperation(value = "1-50-7 金币兑换比率接口", notes = "金币兑换比率接口")
    @GetMapping("/goldRate")
    public Json<BigDecimal> goldRate() {
        return ResultUtil.genSuccessResult(marketProperties.getGoldRate());
    }
}

