package com.bxm.localnews.admin.controller.security;

import com.bxm.component.office.excel.export.impl.SimpleExcelExporter;
import com.bxm.component.office.excel.export.setting.ExcelSheet;
import com.bxm.component.office.excel.export.setting.ExportSetting;
import com.bxm.component.office.excel.export.setting.SheetHeader;
import com.bxm.localnews.admin.dto.ActiveCodeDTO;
import com.bxm.localnews.admin.dto.security.ActiveCardDTO;
import com.bxm.localnews.admin.integration.UserVipIntegrationService;
import com.bxm.localnews.admin.param.security.ActiveCardExportParam;
import com.bxm.localnews.admin.param.security.ActiveCardPageQueryParam;
import com.bxm.localnews.admin.service.security.UserVipService;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 卡激活相关逻辑
 *
 * @author liujia
 * @date 2020/6/1 17:42
 **/
@Api(tags = "9-01 [管理]开卡相关服务", description = "用户卡激活信息相关服务")
@Controller
@RequestMapping("api/admin/user")
public class ActiveCardController extends BaseController {

    private final UserVipIntegrationService userVipIntegrationService;

    private final UserVipService userVipService;

    @Autowired
    public ActiveCardController(UserVipIntegrationService userVipIntegrationService,
                                UserVipService userVipService) {
        this.userVipIntegrationService = userVipIntegrationService;
        this.userVipService = userVipService;
    }

    @ApiOperation("9-01-1 分页获取激活卡列表")
    @ResponseBody
    @RequestMapping(value = "card/page", method = RequestMethod.GET)
    public ResponseJson<PageWarper<ActiveCardDTO>> list(ActiveCardPageQueryParam param) {
        return ResponseJson.ok(userVipService.queryByPage(param));
    }

    @ApiOperation(value = "9-01-2 批量导出卡信息（此方法将返回文件流）", notes = "根据填写的参数导出对应地区的实体卡信息")
    @RequestMapping(value = "card/export", method = RequestMethod.GET)
    public void export(ActiveCardExportParam param, HttpServletResponse response) throws IOException {
        if (param.getExportNum() == null || param.getExportNum() > 10000) {
            logger.error("未指定导出数量或导出超过上限，导出数量：[{}]", param.getExportNum());
            return;
        }
        List<ActiveCodeDTO> result = userVipIntegrationService.batchExport(param.getAreaCode(), param.getExportNum());

        SimpleExcelExporter excelExporter = SpringContextHolder.getBean(SimpleExcelExporter.class);
        ExportSetting setting = new ExportSetting();
        ExcelSheet excelSheet = setting.addSheet();
        excelSheet.setDataCollection(result);
        excelSheet.setFreezeHeader(true);
        excelSheet.setSheetName("卡号与激活码");
        excelSheet.setDefaultWidth(30);

        excelSheet.addHeader(new SheetHeader("卡号", "cardNo"));
        excelSheet.addHeader(new SheetHeader("激活码", "activeCode"));

        processDownload(param.getAreaCode() + "印制卡信息.xls", response);
        excelExporter.export(response.getOutputStream(), setting);
    }
}
























