package com.bxm.localnews.admin.controller.security;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.AdminRoleDTO;
import com.bxm.localnews.admin.dto.MenuDTO;
import com.bxm.localnews.admin.dto.MenuParam;
import com.bxm.localnews.admin.param.RoleParam;
import com.bxm.localnews.admin.service.security.*;
import com.bxm.localnews.admin.vo.security.AdminRole;
import com.bxm.localnews.admin.vo.security.AdminRoleMenu;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Api(tags = "9-06 [管理]角色管理", description = "角色操作接口")
@RestController
@RequestMapping("api/admin/role")
public class AdminRoleController extends CommonController {

    @Resource
    private AdminRoleService adminRoleService;

    @Resource
    private AdminUserRoleService adminUserRoleService;

    @Resource
    private AdminMenuService adminMenuService;

    @Resource
    private AdminRoleMenuService adminRoleMenuService;

    @Resource
    private AdminRolePermService adminRolePermService;

    @ApiOperation(value = "9-06-1 分页获取角色列表", notes = "")
    @GetMapping("list")
    @ResponseBody
    public Json<PageWarper<AdminRoleDTO>> getAllRoleList(RoleParam param) {

        return ResultUtil.genSuccessResult(this.adminRoleService.selectAll(param));
    }

    @ApiOperation(value = "9-06-2 保存角色信息", notes = "")
    @PostMapping(value = "save")
    public Json saveRole(@RequestBody AdminRole adminRole) {
        AdminUser loginUser = this.getLoginUser();

        if (loginUser == null) {
            ResultUtil.genFailedResult("请先登录");
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "请先登录");
        }
        //判断唯一标示
        String roleCode = adminRole.getRoleCode();
        if (StringUtils.isEmpty(roleCode)) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "角色唯一标示为空");
        }
        AdminRole adminRole1 = this.adminRoleService.selectByRoleCode(roleCode);

        if (adminRole.getId() == null) {
            if (adminRole1 != null) {
                return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "角色唯一标示重复");
            }
            adminRole.setCreateTime(new Date());
            adminRole.setCreateUser(loginUser.getId());
            this.adminRoleService.insertSelective(adminRole);
        }

        if (null != adminRole1 && adminRole.getId() != null && null != adminRole.getRoleCode()) {
            if (adminRole1.getRoleCode().equals(adminRole.getRoleCode()) && !adminRole1.getId().equals(adminRole.getId())) {
                return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "角色唯一标示重复");
            }

            adminRole.setUpdateUser(loginUser.getId());
            adminRole.setUpdateTime(new Date());
            this.adminRoleService.updateByPrimaryKeySelective(adminRole);
        }

        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value = "9-06-3 删除角色", notes = "")
    @ApiImplicitParam(name = "roleId", value = "角色id")
    @PostMapping(value = "delete")
    public Json delete(Integer roleId) {
        Integer userNum = this.adminUserRoleService.countByRoleId(roleId);
        if (userNum > 0) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "该角色关联其他用户，不能删除");
        }
        this.adminRoleService.deleteByPrimaryKey(roleId);
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value = "9-06-4 根据角色获取菜单和权限列表", notes = "")
    @ApiImplicitParam(name = "roleId", value = "角色id")
    @GetMapping("getMenuAndPerm")
    public Json<List<MenuDTO>> getMenuAndPerm(Integer roleId) {
        List<MenuDTO> menusAndPermsByRoleId = this.adminMenuService.getMenusAndPermsByRoleId(roleId);

        for (MenuDTO menuDTO : menusAndPermsByRoleId) {
            int i = 0;
            List<MenuDTO> children = menuDTO.getChildren();
            if (children != null && !children.isEmpty()) {
                for (MenuDTO child : children) {
                    if (child.getChecked() == 1) {
                        i++;
                    }
                }
                if (children.size() != i) {
                    menuDTO.setChecked(0);
                }
            }
        }
        return ResultUtil.genSuccessResult(menusAndPermsByRoleId);
    }

    /**
     * 保存角色拥有菜单和权限
     *
     * @param menuParam
     * @return
     */
    @ApiOperation(value = "9-06-5 保存角色拥有菜单和权限", notes = "")
    @PostMapping(value = "saveMenuAndPerm")
    public Json saveMenuAndPerm(@RequestBody MenuParam menuParam) {

        Integer roleId = menuParam.getRoleId();
        if (roleId == null) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "角色id为空");
        }

        AdminRole adminRole = this.adminRoleService.selectByPrimaryKey(roleId);

        if (adminRole != null) {

            //清空角色对应的菜单和权限
            this.adminRoleMenuService.deleteByRoleId(roleId);
            //重新保存
            for (Integer menuId : menuParam.getMenuIds()) {
                AdminRoleMenu adminRoleMenu = new AdminRoleMenu();
                adminRoleMenu.setMenuId(menuId);
                adminRoleMenu.setRoleId(roleId);
                this.adminRoleMenuService.insertSelective(adminRoleMenu);
            }
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "角色不存在");
    }

}