package com.bxm.localnews.admin.controller.security;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.dto.UserBlockDTO;
import com.bxm.localnews.admin.dto.UserManageDTO;
import com.bxm.localnews.admin.dto.security.UserInfoDTO;
import com.bxm.localnews.admin.integration.UserVipIntegrationService;
import com.bxm.localnews.admin.param.AddTimesParam;
import com.bxm.localnews.admin.param.UserBecomeTalentParam;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.param.UserManageParam;
import com.bxm.localnews.admin.param.security.UserPhoneParam;
import com.bxm.localnews.admin.service.base.AdminChannelService;
import com.bxm.localnews.admin.service.base.TalentMangeService;
import com.bxm.localnews.admin.service.security.AdminBlockUserService;
import com.bxm.localnews.admin.service.security.AdminUserBaseInfoService;
import com.bxm.localnews.admin.service.security.ManageUserAdminInfoService;
import com.bxm.localnews.admin.vo.Channel;
import com.bxm.localnews.admin.vo.MerchantUserVO;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@Api(tags = "1-17 [管理]用户管理", description = "用户相关操作")
@RestController
@RequestMapping("api/admin/user")
public class AdminUserManageController {

    /**
     * 日志对象
     */
    private static final Logger LOG = LoggerFactory.getLogger(AdminUserManageController.class);

    @Resource
    private AdminChannelService adminChannelService;

    @Resource
    private AdminUserBaseInfoService adminUserBaseInfoService;

    @Autowired
    private AdminBlockUserService blockUserService;

    @Autowired
    private UserVipIntegrationService userVipIntegrationService;

    @Autowired
    private ManageUserAdminInfoService manageUserAdminInfoService;

    @Autowired
    private TalentMangeService talentMangeService;

    @ApiOperation(value = "1-17-1 根据条件获取用户信息列表", notes = "")
    @RequestMapping(value = "queryUserInfoList", method = RequestMethod.GET)
    @ResponseBody
    public Json<PageWarper<UserInfoDTO>> queryUserInfoList(UserInfoParam userInfoParam) {

        LOG.info("获取用户信息列表的查询参数为:{}", JSON.toJSONString(userInfoParam));
        return ResultUtil.genSuccessResult(this.adminUserBaseInfoService.queryUserInfoDTO(userInfoParam));
    }


    @ApiOperation(value = "1-17-2 查看用户基本信息", notes = "")
    @ApiImplicitParam(name = "userId", value = "用户id")
    @RequestMapping(value = "queryUserBaseInfoByUserId", method = RequestMethod.GET)
    @ResponseBody
    public Json<User> queryUserInfoByUserId(@RequestParam(value = "userId", required = false) String userId) {

        if (StringUtils.isEmpty(userId)) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "参数错误");
        }

        User userBaseInfo = this.adminUserBaseInfoService.selectByUserId(Long.parseLong(userId));
        if (userBaseInfo == null) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "用户不存在");
        }

        return ResultUtil.genSuccessResult(userBaseInfo);
    }

    @ApiOperation(value = "1-17-3 设置和取消用户黑名单", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "state", value = "状态")
    })
    @RequestMapping(value = "updateUserBlack", method = RequestMethod.GET)
    @ResponseBody
    public Json updateUserBlack(@RequestParam(value = "userId", required = false) String userId,
                                @RequestParam(value = "state", required = false) String state) {
        if (StringUtils.isEmpty(String.valueOf(userId)) || StringUtils.isEmpty(state)) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "参数错误");
        }
        Map<String, Object> map = Maps.newHashMap();
        map.put("userId", userId);
        map.put("state", state);

        boolean flag = this.adminUserBaseInfoService.updateUserBlack(map);
        if (flag) {
            return ResultUtil.genSuccessMsg("操作成功");
        } else {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "操作失败");
        }
    }

    @ApiOperation(value = "1-17-4 获取渠道列表", notes = "")
    @RequestMapping(value = "getChannelList", method = RequestMethod.GET)
    @ResponseBody
    public Json<List<Channel>> getChannelList() {
        List<Channel> channelList = this.adminChannelService.selectRegistChannelList();
        return ResultUtil.genSuccessResult(channelList);
    }

    @ApiOperation(value = "1-17-5 删除用户", notes = "")
    @RequestMapping(value = "delete", method = RequestMethod.POST)
    @ApiImplicitParam(name = "userId", value = "用户id")
    public Json deleteUser(@RequestParam("userId") Long userId) {
        this.adminUserBaseInfoService.deleteUser(userId);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "1-17-6 获取虚拟用户列表")
    @RequestMapping(value = "getVirtualUserList", method = RequestMethod.GET)
    public Json<List<UserInfoDTO>> getVirtualUserList() {
        return ResultUtil.genSuccessResult(this.adminUserBaseInfoService.getVirtualUserList());
    }

//    @ApiOperation(value = "1-17-7 添加虚拟用户")
//    @RequestMapping(value = "addVirtualUser", method = RequestMethod.POST)
//    public Json addVirtualUser(String nickName, String headImg) {
//        if(this.adminUserBaseInfoService.addVirtualUser(nickName, headImg)){
//            return ResultUtil.genSuccessMsg();
//        }
//        return ResultUtil.genFailedResult("添加失败");
//    }

    @ApiOperation(value = "1-17-7 获取用户限制信息")
    @GetMapping(value = "/block/info")
    public Json<UserBlockDTO> getBlockInfo(@RequestParam Long userId) {

        return ResultUtil.genSuccessResult(blockUserService.getInfo(userId));
    }

    @ApiOperation(value = "1-17-8 编辑用户限制信息")
    @PostMapping(value = "/block/edit")
    public Json<Boolean> editBlockInfo(@RequestBody UserBlockDTO userBlockDTO) {

        return ResultUtil.genSuccessResult(blockUserService.editUserBlock(userBlockDTO));
    }

    @ApiOperation(value = "1-17-9 设置激活码次数", notes = "用户如果还不是VIP则会直接激活为VIP")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", paramType = "Long", required = true),
            @ApiImplicitParam(name = "num", value = "更新次数", paramType = "Integer", required = true)
    })
    @PostMapping(value = "setActivationNum")
    public ResponseJson<Boolean> setActivationNum(@RequestParam Long userId, @RequestParam Integer num) {
        AddTimesParam param = new AddTimesParam();
        param.setUserId(userId);
        param.setTimes(num);

        return ResponseJson.build(userVipIntegrationService.addNum(param));
    }

    @ApiOperation(value = "1-17-10 设置用户手机号码",
            notes = "通过运营后台修改用户手机号码，如果号码已绑定其他用户，则返回code为400，需要显示对应的错误消息")
    @PostMapping(value = "setPhoneNo")
    public ResponseJson setPhoneNo(@RequestBody UserPhoneParam param) {
        return ResponseJson.build(adminUserBaseInfoService.modifyPhoneNo(param));
    }

    @ApiOperation(value = "1-17-11 获取用户管理员信息")
    @GetMapping(value = "/admin/info")
    public Json<UserManageDTO> getAdminInfo(@RequestParam Long userId) {
        return Json.build(manageUserAdminInfoService.getAdminInfo(userId));
    }

    @ApiOperation(value = "1-17-12 编辑用户管理员信息")
    @PostMapping(value = "/admin/edit")
    public Json editAdminInfo(@RequestBody UserManageParam param) {
        return Json.build(manageUserAdminInfoService.editAdminInfo(param));
    }

    @ApiOperation(value = "1-17-13 普通用户升级为达人")
    @PostMapping(value = "/becomeTalent")
    public ResponseJson becomeTalent(@RequestBody UserBecomeTalentParam param) {
        Message result = talentMangeService.becomeTalent(param);
        if (Boolean.FALSE.equals(result.isSuccess())) {
            return ResponseJson.badReqeuset(result.getLastMessage()).build();
        }
        return ResponseJson.ok().build();
    }

    @ApiOperation(value = "1-17-14 获取所有商家用户信息")
    @GetMapping(value = "/getAllMerchantUser")
    public ResponseJson<List<MerchantUserVO>> getAllMerchantUser(@RequestParam(value = "nickname", required = false) String nickname) {
        return ResponseJson.ok(adminUserBaseInfoService.queryMerchantUserList(nickname));
    }
}
