package com.bxm.localnews.admin.controller.security;

import com.bxm.localnews.admin.integration.UserAuthCodeIntegrationService;
import com.bxm.localnews.admin.param.security.UserAuthCodeParam;
import com.bxm.localnews.admin.param.security.UserRoleParam;
import com.bxm.localnews.common.vo.Json;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "9-03 用户权限管理", description = "运营后台维护用户的角色权限")
@RestController
@RequestMapping("api/admin/user/auth")
public class UserAuthController {

    private final UserAuthCodeIntegrationService userAuthCodeIntegrationService;

    @Autowired
    public UserAuthController(UserAuthCodeIntegrationService userAuthCodeIntegrationService) {
        this.userAuthCodeIntegrationService = userAuthCodeIntegrationService;
    }

    @ApiOperation("9-03-1 设置用户角色")
    @PostMapping("role/add")
    public Json<Boolean> addRole(@RequestBody UserRoleParam param) {
        return Json.ok(userAuthCodeIntegrationService.addRole(param));
    }

    @ApiOperation("9-03-2 移除用户角色信息")
    @PostMapping("role/remove")
    public Json<Boolean> removeRole(@RequestBody UserRoleParam param) {
        return Json.ok(userAuthCodeIntegrationService.removeRole(param));
    }

    @ApiOperation("9-03-3 添加用户权限")
    @PostMapping("auth/add")
    public Json<Boolean> addAuth(@RequestBody UserAuthCodeParam param) {
        return Json.ok(userAuthCodeIntegrationService.addAuth(param));
    }

}
