package com.bxm.localnews.admin.controller.security;

import com.bxm.component.office.excel.parse.impl.SimpleExcelParser;
import com.bxm.component.office.excel.parse.setting.ParseHeader;
import com.bxm.component.office.excel.parse.setting.ParseSetting;
import com.bxm.localnews.admin.dto.BatchActiveDTO;
import com.bxm.localnews.admin.dto.ImportResultDTO;
import com.bxm.localnews.admin.dto.OrderInfoDTO;
import com.bxm.localnews.admin.facade.PaymentOrderFacadeService;
import com.bxm.localnews.admin.integration.UserVipIntegrationService;
import com.bxm.localnews.admin.param.OfflineBindRelationParam;
import com.bxm.localnews.admin.param.PayRefundParam;
import com.bxm.localnews.admin.param.UserActivationCardParam;
import com.bxm.localnews.admin.param.UserRefundOrderParam;
import com.bxm.localnews.admin.param.security.MuanalActiveVipParam;
import com.bxm.localnews.admin.service.security.AdminUserService;
import com.bxm.localnews.admin.service.security.VipCardService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.List;

/**
 * @author liujia
 * @date 2020/6/1 18:11
 **/
@Api(tags = "9-02 [管理]VIP卡开卡相关管理功能", description = "包含用户开卡情况，运营手工开卡等功能")
@RequestMapping("api/admin/activationCard")
@RestController
@Slf4j
public class VipCardController {
    @Resource
    private AdminUserService adminUserService;

    @Resource
    private PaymentOrderFacadeService paymentOrderFacadeService;

    @Resource
    private UserVipIntegrationService userVipIntegrationService;

    @Resource
    private VipCardService vipCardService;

    @ApiOperation(value = "9-02-1 开卡管理分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "phone", value = "手机号码", paramType = "string"),
            @ApiImplicitParam(name = "activationStatus", value = "激活状态:0未激活 1：已激活", allowableValues = "0,1", paramType = "int"),
            @ApiImplicitParam(name = "payStatus", value = "支付状态1:待付款 2：取消付款 3：付款成功 4：付款失败 5：付款超时", allowableValues = "1,2,3,4,5", paramType = "int"),
    })
    @GetMapping("list")
    public ResponseJson<PageWarper<OrderInfoDTO>> queryPage(@ApiIgnore UserActivationCardParam userActivationCardParam) {
        return ResponseJson.ok(adminUserService.getOpenCardPageList(userActivationCardParam));
    }

    @ApiOperation(value = "9-02-2 申请退款", notes = "如果用户开卡为自费开发，允许进行退款操作")
    @PostMapping("refund")
    public ResponseJson<Boolean> refundOrder(@RequestBody UserRefundOrderParam userRefundOrderParam) {
        PayRefundParam payRefundParam = new PayRefundParam();
        BeanUtils.copyProperties(userRefundOrderParam,payRefundParam);
        return ResponseJson.ok(paymentOrderFacadeService.submitRefund(payRefundParam).getResult().isSuccess());
    }

    @ApiOperation(value = "9-02-3 批量激活用户VIP", notes = "用于批量激活用户VIP资格信息")
    @ApiImplicitParam(name = "excelFile", value = "导入的Excel文件")
    @RequestMapping(value = "batch/active", method = RequestMethod.POST)
    public ResponseJson<List<ImportResultDTO>> batchActive(@RequestParam("excelFile") MultipartFile excelFile) {
        if (null == excelFile) {
            return ResponseJson.badReqeuset("请求参数未发现参数名为[excelFile]的文件流").build();
        }

        SimpleExcelParser<MuanalActiveVipParam> parser = SpringContextHolder.getBean(SimpleExcelParser.class);
        ParseSetting setting = new ParseSetting()
                .setEntityClasz(MuanalActiveVipParam.class)
                .setHeaderModel(true);

        setting.addHead(new ParseHeader("用户名", "realName"));
        setting.addHead(new ParseHeader("手机号码", "phoneNo"));

        try {
            List<ImportResultDTO> responseRes = Lists.newArrayList();

            List<MuanalActiveVipParam> result = parser.parse(excelFile.getInputStream(), setting);

            for (MuanalActiveVipParam param : result) {
                if (StringUtils.isBlank(param.getPhoneNo())) {
                    continue;
                }

                ImportResultDTO importResultDTO = userVipIntegrationService.manualActiveVip(param.getPhoneNo());

                if (null != importResultDTO && !importResultDTO.getSuccess()) {
                    responseRes.add(importResultDTO);
                }
            }

            return ResponseJson.ok(responseRes);
        } catch (IOException e) {
            log.error(e.getMessage(), e);
            return ResponseJson.badReqeuset("上传的文件无法读取，请确认格式是否正确").build();
        }
    }

    @ApiOperation(value = "9-02-4 批量创建师徒关联关系", notes = "用于批量绑定渠道BD与商户的上下级关系")
    @ApiImplicitParam(name = "excelFile", value = "导入的Excel文件")
    @RequestMapping(value = "batch/relation", method = RequestMethod.POST)
    public ResponseJson<List<ImportResultDTO>> batchRelation(@RequestParam("excelFile") MultipartFile excelFile) {
        if (null == excelFile) {
            return ResponseJson.badReqeuset("请求参数未发现参数名为[excelFile]的文件流").build();
        }

        SimpleExcelParser<OfflineBindRelationParam> parser = SpringContextHolder.getBean(SimpleExcelParser.class);
        ParseSetting setting = new ParseSetting()
                .setEntityClasz(OfflineBindRelationParam.class)
                .setHeaderModel(true);

        setting.addHead(new ParseHeader("卡号", "cardNo"));
        setting.addHead(new ParseHeader("激活码", "activeCode"));
        setting.addHead(new ParseHeader("手机号码", "phoneNo"));

        try {
            List<OfflineBindRelationParam> result = parser.parse(excelFile.getInputStream(), setting);

            return ResponseJson.ok(userVipIntegrationService.batchBind(result));
        } catch (IOException e) {
            log.error(e.getMessage(), e);
            return ResponseJson.badReqeuset("上传的文件无法读取，请确认格式是否正确").build();
        }
    }

    @ApiOperation(value = "9-02-5 手机号激活用户VIP", notes = "手机号激活用户VIP资格信息")
    @ApiImplicitParam(name = "phone", value = "phone")
    @GetMapping(value = "phone/active")
    public ResponseJson<ImportResultDTO> phoneActive(@RequestParam("phone") String phone) {
        return ResponseJson.ok(userVipIntegrationService.manualActiveVip(phone));
    }

    @ApiOperation(value = "9-02-6 根据手机号批量激活", notes = "如果手机号不存在则保存，定时刷新激活")
    @ApiImplicitParam(name = "phones", value = "多个手机号根据换行符分割")
    @GetMapping(value = "phone/saveAndActive")
    public ResponseJson batchSavePhoneActive(String phones) {
        vipCardService.batchSavePhoneActive(phones);
        return ResponseJson.ok().build();
    }

    @ApiOperation(value = "9-02-7 查询缓存中的所有手机号", notes = "没有做分页，一次性全部返回的")
    @GetMapping(value = "phone/listAllPhones")
    public ResponseJson<List<BatchActiveDTO>> listAllPhones() {
        ;
        return ResponseJson.ok(vipCardService.listAllPhones());
    }
}