package com.bxm.localnews.admin.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块} 业务类型： biz:业务 config:配置
 */
public class RedisConfig {

    /**
     * =============================== spider模块 =================================
     */

    /**
     * 公共标签记录
     */
    public static final KeyGenerator SPIDER_TAG_INDEX = DefaultKeyGenerator.build("sync", "spider", "tag");

    /**
     * =============================== thirdparty模块 =================================
     */

    /**
     * 广告类列表
     */
    public static KeyGenerator THIRDPARTY_TYPE_ADVERT = DefaultKeyGenerator.build("thirdparty", "advert");

    /**
     * 工具类列表(7天过期)
     */
    public static KeyGenerator THIRDPARTY_AREACODE_TOOLS = DefaultKeyGenerator.build("thirdparty",
            "areacode_tools");

    /**
     * 短链接
     */
    public static KeyGenerator SHORT_URL = DefaultKeyGenerator.build("thirdparty", "cache",
            "short_url");

    /**
     * 积分商城列表
     */
    public static KeyGenerator POINTS_MALL_KEY = DefaultKeyGenerator.build("thirdparty", "pointsMall");

    /**
     * =============================== activity模块 =================================
     */

    /**
     * 活动列表缓存
     */
    public static KeyGenerator PRIVILEGE_lIST = DefaultKeyGenerator.build("activity",
            "privilege_list");

    /**
     * 投票插件基础信息
     */
    public static KeyGenerator VOTE_INFO_KEY = DefaultKeyGenerator.build("activity", "vote", "info");

    /**
     * 投票插件各选项投票结果
     */
    public static KeyGenerator VOTE_OPTIONS_KEY = DefaultKeyGenerator.build("activity", "vote", "option");

    /**
     * =============================== user模块 =================================
     */

    /**
     * 用户信息 key-field-value
     */
    public static KeyGenerator USER_INFO = DefaultKeyGenerator.build("user", "cache", "userInfo");

    /**
     * ============================= base模块 ==========================
     */

    /**
     * 区域信息
     */
    public static KeyGenerator AREA_INFO = DefaultKeyGenerator.build("base", "area", "info");

    /**
     * 热门城市信息
     */
    public static KeyGenerator HOT_LOCATION = DefaultKeyGenerator.build("base", "location", "hot");

    /**
     * 定位城市信息
     */
    public static KeyGenerator OPENED_LOCATION = DefaultKeyGenerator.build("base", "location",
            "opened");

    /**
     * channel 所有渠道版本信息
     */
    public static KeyGenerator BASE_APPVERSION_CHANNEL = DefaultKeyGenerator.build("base",
            "appversion_channel");

    /**
     * 客服信息 key-field-value
     */
    public static KeyGenerator CUSTOMER_SERVICE_INFO = DefaultKeyGenerator.build("base", "location", "customer_service_info");

    /**
     * ============================= news模块 =============================
     */

    /**
     * 新闻类型缓存
     */
    public static KeyGenerator NEWS_KIND = DefaultKeyGenerator.build("news", "cache", "newskind");

    /**
     * 用户频道缓存
     */
    public static KeyGenerator NEWS_USER_KIND = DefaultKeyGenerator.build("news", "kind", "user_list");

    /**
     * 用户频道set缓存
     */
    public static KeyGenerator NEWS_USER_KIND_SET = DefaultKeyGenerator.build("news", "kind", "user_set");

    /**
     * 小视频队列
     */
    public static KeyGenerator VIDEO_QUEUE = DefaultKeyGenerator.build("video", "queue");

    public static KeyGenerator SEQ_NEWS_ID = DefaultKeyGenerator.build("seq", "news", "id");

    public static KeyGenerator SEQ_POST_ID = DefaultKeyGenerator.build("seq", "post", "id");

    /**
     * 全局的新闻黑名单key
     */
    public static KeyGenerator NEWS_BLACK = DefaultKeyGenerator.build("news", "black");

    /**
     * 首页置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_LIST = DefaultKeyGenerator.build("news", "top");

    /**
     * 首页区域性置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_OF_AREA_LIST = DefaultKeyGenerator.build("news", "top");

    /**
     * 首页全国性置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_OF_WHOLE_COUNTRY_LIST = DefaultKeyGenerator.build("news", "top",
            "wholeCountry");

    /**
     * 社区版块缓存
     */
    public static KeyGenerator FORUM = DefaultKeyGenerator.build("forum", "cache", "forum");

    /**
     * 社区话题缓存
     */
    public static KeyGenerator TOPIC = DefaultKeyGenerator.build("forum", "cache", "topic");

    /**
     * 论坛帖子相关模块
     */
    public static KeyGenerator FORUM_RECOMMENDED = DefaultKeyGenerator.build("forum", "recommended");

    /**
     * 发放红花验证码存储
     */
    public static KeyGenerator CACULATE_FLOWER = DefaultKeyGenerator.build("activity", "caculate","flower");

    /**
     * 地区黑白名单列表
     */
    public static KeyGenerator AREA_WHITE_BLACK_LIST = DefaultKeyGenerator.build("base", "area_white_black_list");

    /**
     * 聊天屏蔽缓存
     */
    public static KeyGenerator IM_BLOCK_LIST = DefaultKeyGenerator.build("im", "block_list");

}
