/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ImportUtils {
    private static final Logger logger = LoggerFactory.getLogger(ImportUtils.class);
    private static final String EXCEL_2003_REGEX = "^.+\\.(?i)(xls)$";
    private static final String EXCEL_2007_REGEX = "^.+\\.(?i)(xlsx)$";

    public static List<List<String>> readExcelFile(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        logger.debug("\u5bfc\u5165\u6587\u4ef6\u540d\uff1a" + fileName);
        try {
            if (null == fileName) {
                return null;
            }
            boolean isExcel2003 = fileName.matches(EXCEL_2003_REGEX);
            boolean isExcel2007 = fileName.matches(EXCEL_2007_REGEX);
            if (!isExcel2003 && !isExcel2007) {
                logger.warn("\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u662fexcel");
                return null;
            }
            return ImportUtils.createExcel(file.getInputStream(), isExcel2003);
        }
        catch (Exception e) {
            logger.error("excel\u89e3\u6790\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    public static List<List<String>> createExcel(InputStream is, boolean isExcel2003) {
        try {
            Object wb = isExcel2003 ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            return ImportUtils.readExcelValue((Workbook)wb);
        }
        catch (IOException e) {
            logger.error("excel\u521d\u59cb\u5316\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    private static List<List<String>> readExcelValue(Workbook wb) {
        logger.debug("\u5f00\u59cb\u89e3\u6790excel\u6570\u636e...");
        Sheet sheet = wb.getSheetAt(0);
        int totalRows = sheet.getPhysicalNumberOfRows();
        int totalCells = 0;
        if (totalRows > 1 && sheet.getRow(0) != null) {
            totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
        }
        logger.debug("\u884c\u6570\uff1a" + totalRows + "\u5217\u6570\uff1a" + totalCells);
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        for (int r = 1; r < totalRows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            ArrayList<String> list = new ArrayList<String>();
            for (int c = 0; c < totalCells; ++c) {
                Cell cell = row.getCell(c);
                if (null == cell) continue;
                if (cell.getCellType() == CellType.NUMERIC) {
                    String name;
                    list.add(name.substring(0, (name = String.valueOf(cell.getNumericCellValue())).length() - 2 > 0 ? name.length() - 2 : 1));
                    continue;
                }
                list.add(cell.getStringCellValue());
            }
            if (!CollectionUtils.isNotEmpty(list)) continue;
            logger.debug("\u5355\u5217\u6570\u636e\uff1a" + list);
            resultList.add(list);
        }
        return resultList;
    }
}

