package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.dto.ChannelAreaDTO;
import com.bxm.localnews.admin.vo.LocationChannelAreaBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * ALocationChannelAreaDAO继承基类
 */
@Mapper
public interface LocationChannelAreaMapper {

    /**
     * @param id
     * @return
     */
    LocationChannelAreaBean selectByPrimaryKey(Long id);

    /**
     * 删除信息
     *
     * @param id
     * @return
     */
    int deleteByPrimaryKey(Long id);

    /**
     * 新增
     *
     * @param locationChannelAreaBean
     * @return
     */
    int insert(LocationChannelAreaBean locationChannelAreaBean);

    /**
     * 选择性新增
     *
     * @param locationChannelAreaBean
     * @return
     */
    int insertSelective(LocationChannelAreaBean locationChannelAreaBean);

    /**
     * 获取地里位置信息
     *
     * @param locationChannelId ： 栏目id
     * @return
     */
    List<ChannelAreaDTO> getListByChannelId(Long locationChannelId);

    /**
     * 删除区域位置信息
     *
     * @param locationChannelId：栏目id
     * @return
     */
    int deleteByLocationId(Long locationChannelId);

    /**
     * 批量新增广告位信息
     *
     * @param list
     * @return
     */
    int batchInsert(@Param("list") List<ChannelAreaDTO> list);
}