package com.bxm.localnews.admin.domain;


import com.bxm.localnews.admin.param.UserChannelParam;
import com.bxm.localnews.admin.vo.LocationChannelBean;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;


@Mapper
public interface LocationChannelMapper {


    /**
     * 新增
     *
     * @param record
     * @return
     */
    int insert(LocationChannelBean record);

    /**
     * 选择性新增
     *
     * @param record
     * @return
     */
    int insertSelective(LocationChannelBean record);

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    LocationChannelBean selectByPrimaryKey(Long id);

    /**
     * 获取可用的栏目信息
     *
     * @return 可用栏目信息
     */
    List<LocationChannelBean> getEnableChannel();

    /**
     * 根据id更新
     *
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(LocationChannelBean record);

    /**
     * 根据id所有更新
     *
     * @param record
     * @return
     */
    int updateByPrimaryKey(LocationChannelBean record);

    /**
     * 获取分页栏目数据
     *
     * @param userChannelParam
     * @return
     */
    List<LocationChannelBean> getList(UserChannelParam userChannelParam);

    /**
     * 更新栏目状态信息： 根据数据库状态更新
     *
     * @param id
     * @return
     */
    int updateStatus(Long id);

}