package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.vo.ParticipantBean;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface ParticipantMapper {

    /**
     * 获取活动邀请人数排行第一的用户
     * @param privilegeId 活动ID
     * @return 排行第一的用户ID
     */
    ParticipantBean getTopUser(long privilegeId);

    int deleteByPrimaryKey(Long id);

    int insert(ParticipantBean record);

    ParticipantBean selectByPrimaryKey(Long id);

    int updateByPrimaryKey(ParticipantBean record);

    /**
     * 获取参与活动的全部用户列表
     * @param privilegeId 活动ID
     * @return 用户列表
     */
    List<ParticipantBean> getParticipantList(long privilegeId);

}