/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.vo.UserInviteHistoryBean;
import com.bxm.localnews.admin.dto.Tuple;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author : jieli.xu
 * @date 2020/5/26 14:20
 */
@Mapper
public interface UserInviteHistoryMapper {

    /**
     * 更新收徒表的vip状态
     * @param invitedUserId ： 被邀请人id
     * @return
     */
    int updateInvitedUserIdVip(@Param("invitedUserId")Long invitedUserId);

    /**
     * 删除师徒关系
     * @param invitedUserId ：
     * @return
     */
    int delete(@Param("invitedUserId")Long invitedUserId);

    /**
     * 查询用户的邀请关系
     * @param userId ： 用户id
     * @return
     */
    UserInviteHistoryBean selectByUserId(@Param("userId") Long userId);

    /**
     * 获取用户的收徒统计数据
     * @param userId 用户ID
     * @return 每日收徒数量统计
     */
    List<Tuple> getCollect(Long userId);

    /**
     * 获取不同等级的收徒人数
     * @param userId ： 用户id
     * @param level ： 等级
     * @return
     */
    Integer getCollectLevel(@Param("userId") Long userId, @Param("level") Integer level);
}
