package com.bxm.localnews.admin.domain.medal;


import com.bxm.localnews.admin.entity.medal.UserMedalInfoEntity;
import com.bxm.localnews.admin.param.medal.MedalQueryParam;
import com.bxm.localnews.admin.vo.medal.CustomMedalSelectVO;
import com.bxm.localnews.admin.vo.medal.MedalListVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface UserMedalInfoMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserMedalInfoEntity record);

    int insertSelective(UserMedalInfoEntity record);

    UserMedalInfoEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserMedalInfoEntity record);

    int updateByPrimaryKey(UserMedalInfoEntity record);

    /**
     * 查询定制勋章列表
     *
     * @param param 查询入参
     * @return 定制勋章列表
     */
    List<MedalListVO> getCustomMealList(MedalQueryParam param);

    /**
     * 查询所有可用的定制勋章列表
     *
     * @param type    0：按照勋章id查询，1：按照勋章名称模糊匹配
     * @param keyword 查询关键字
     * @param allType 是否查询所有勋章，0：只查询未过期的勋章，1：查询所有勋章
     * @return 定制勋章列表
     */
    List<CustomMedalSelectVO> getUsableCustomMedalList(@Param("type") int type,
                                                       @Param("keyword") String keyword,
                                                       @Param("allType") Integer allType);

    /**
     * 增加勋章的授予数量
     *
     * @param medalId 勋章id
     * @return 影响行数
     */
    int increaseGrantNum(@Param("medalId") Long medalId);


    /**
     * 获取所有有效的定制勋章
     *
     * @return 有效的定制勋章列表
     */
    List<UserMedalInfoEntity> getAllUsableMedal();

    /**
     * 批量更新定制勋章状态
     *
     * @param expiredMedalIdList 定制勋章id列表
     * @param status             要更新的状态
     * @return 影响行数
     */
    int batchUpdateCustomStatus(@Param("expiredMedalIdList") List<Long> expiredMedalIdList,
                                @Param("status") int status);
}