package com.bxm.localnews.admin.domain.medal;

import com.bxm.localnews.admin.entity.medal.UserMedalRelationInfoEntity;
import com.bxm.localnews.admin.vo.medal.CustomMedalVO;
import com.bxm.localnews.admin.vo.medal.MedalMiniVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface UserMedalRelationInfoMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserMedalRelationInfoEntity record);

    int insertSelective(UserMedalRelationInfoEntity record);

    UserMedalRelationInfoEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserMedalRelationInfoEntity record);

    int updateByPrimaryKey(UserMedalRelationInfoEntity record);

    /**
     * 统计用户的成就勋章总数
     *
     * @param userId 用户id
     * @return 成就勋章勋章总数
     */
    int countUserAchievementMedalNum(@Param("userId") Long userId);

    /**
     * 统计用户的定制勋章总数
     *
     * @param userId 用户id
     * @return 定制勋章总数
     */
    int countUserCustomMedalNum(@Param("userId") Long userId);

    /**
     * 获取用户的成就勋章列表
     *
     * @param userId 用户id
     * @return 成就勋章列表
     */
    List<MedalMiniVO> getUserAchievementMedalList(@Param("userId") Long userId);

    /**
     * 获取用户的定制勋章列表
     *
     * @param userId 用户id
     * @return 定制勋章列表
     */
    List<CustomMedalVO> getUserCustomMedalList(@Param("userId") Long userId);

    /**
     * 逻辑删除用户勋章
     *
     * @param userId        用户id
     * @param medalId       勋章id
     * @param deletedReason 删除原因
     * @return 影响记录行数
     */
    int removeUserMedalByUserIdAndMedalId(@Param("userId") Long userId,
                                          @Param("medalId") Long medalId,
                                          @Param("deletedReason") String deletedReason);

    /**
     * 获取用户勋章获得记录通过用户id和勋章id
     *
     * @param userId  用户id
     * @param medalId 勋章id
     * @return 用户获得记录
     */
    UserMedalRelationInfoEntity getByUserIdAndMedalId(@Param("userId") Long userId,
                                                      @Param("medalId") Long medalId);

    /**
     * 批量更新取消佩戴定制勋章
     *
     * @param expiredMedalIdList 过期的勋章id
     * @param wearStatus         佩戴状态
     * @return 影响行数
     */
    int batchUpdateHasWearStatus(@Param("expiredMedalIdList") List<Long> expiredMedalIdList,
                                 @Param("wearStatus") int wearStatus);
}