package com.bxm.localnews.admin.service;

import com.bxm.localnews.admin.param.MonitorTaskBuildParam;
import com.bxm.localnews.admin.param.PublishNewsBuildParam;
import com.bxm.localnews.admin.param.PushMsgBuildParam;
import com.bxm.localnews.admin.service.fallback.QuartzIntegrationFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-quartz", fallbackFactory = QuartzIntegrationFallbackFactory.class)
@RequestMapping("quartz")
public interface QuartzIntegrationService {

    /**
     * 1-1-1 构建新闻监控的定时任务
     * @param param
     * @return
     */
    @PostMapping("/add/monitor")
    ResponseEntity<String> addMonitor(@RequestBody MonitorTaskBuildParam param);

    /**
     * 1-1-2 移除新闻监控的定时任务
     * @param indexId
     * @return
     */
    @PostMapping("/remove/monitor")
    ResponseEntity<String> removeMonitor(@RequestParam("indexId") Long indexId);

    /**
     * 1-1-3 添加新闻发布的定时任务（仅运行一次）
     * @param param
     * @return
     */
    @PostMapping("/add/publish")
    ResponseEntity<String> addPublish(@RequestBody PublishNewsBuildParam param);

    /**
     * 1-1-4 添加消息推送的定时任务(仅运行一次)
     * @param param
     * @return
     */
    @PostMapping("/add/push")
    ResponseEntity<String> addPush(@RequestBody PushMsgBuildParam param);

    /**
     * 1-1-5 移除推送的定时任务
     * @param messageId
     * @return
     */
    @PostMapping("/remove/push")
    ResponseEntity<String> removePush(Long messageId);
}
