package com.bxm.localnews.admin.service;

import com.bxm.localnews.admin.dto.ContentDTO;
import com.bxm.localnews.admin.param.CrawlingParam;
import com.bxm.localnews.admin.service.fallback.SpiderManageFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "manager-service", fallbackFactory = SpiderManageFallbackFactory.class)
public interface SpiderManageService {

    @PostMapping("/spider/pageDownload")
    ResponseEntity<ContentDTO> pageDownload(@RequestBody CrawlingParam crawlingParam);

}
