package com.bxm.localnews.admin.service.fallback;

import com.bxm.localnews.admin.param.NewsSimpleParam;
import com.bxm.localnews.admin.service.NewsSyncService;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class NewsSyncFallbackFactory implements FallbackFactory<NewsSyncService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsSearchFallbackFactroy.class);

    @Override
    public NewsSyncService create(Throwable throwable) {

        return newsSimpleParam -> {
            LOGGER.error(throwable.getMessage(), throwable);
            return null;
        };
    }
}