package com.bxm.localnews.admin.service.fallback;

import com.bxm.localnews.admin.service.SpiderManageService;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiderManageFallbackFactory implements FallbackFactory<SpiderManageService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzIntegrationFallbackFactory.class);

    @Override
    public SpiderManageService create(Throwable throwable) {
        return crawlingParam -> {
            LOGGER.error(crawlingParam.toString());
            LOGGER.error(throwable.getMessage(), throwable);
            return null;
        };
    }
}
