package com.bxm.localnews.admin.facade;

import com.bxm.localnews.admin.dto.im.BlockUserDTO;
import com.bxm.localnews.admin.facade.fallback.IMFallbackFactory;
import com.bxm.localnews.admin.param.BatchMessageParam;
import com.bxm.localnews.admin.param.ChatRoomOperationParam;
import com.bxm.localnews.admin.param.CreateRedPacketTaskFacadeParam;
import com.bxm.localnews.admin.param.RemoveRedPacketTaskFacadeParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(value = "localnews-im", fallbackFactory = IMFallbackFactory.class,primary = false)
@RequestMapping("facade/im")
public interface IMFacadeService {

    @ApiOperation(value = "7-99-1 用户封禁", notes = "封禁后的用户无法发送消息给其他用户")
    @PostMapping("block")
    ResponseEntity<Boolean> block(@RequestParam("userId") Long userId, @RequestParam("minutes") int minutes);

    @ApiOperation(value = "7-99-2 解除用户封禁", notes = "解除封禁后可正常发送消息")
    @PostMapping("unblock")
    ResponseEntity<Boolean> unblock(@RequestParam("userId") Long userId);

    @ApiOperation(value = "7-99-4  获取用户token", notes = "提供给服务内部用于获取用户的会话token")
    @GetMapping("token")
    ResponseEntity<String> token(@RequestParam("userId") Long userId);

    @PostMapping("createChatRoom")
    ResponseEntity<Boolean> createChatRoom(@RequestParam("areaCode") String areaCode,
                                           @RequestParam("assistantUserId")Long assistantUserId,
                                           @RequestParam("areaName") String areaName);

    /**
     * 创建定时红包的任务
     * @param param
     * @return
     */
    @PostMapping("createRedPacketTask")
    ResponseEntity<Boolean> createRedPacketTask(@RequestBody CreateRedPacketTaskFacadeParam param);

    /**
     * 移除定时红包的任务
     * @param param
     * @return
     */
    @PostMapping("removeRedPacketTask")
    ResponseEntity<Boolean> removeRedPacketTask(@RequestBody RemoveRedPacketTaskFacadeParam param);

    /**
     * 获取聊天室禁言用户
     * @param chatRoomId
     * @return
     */
   @GetMapping("queryChatRoomBlockUser")
	ResponseEntity<List<BlockUserDTO>> queryChatRoomBlockUser(@RequestParam("chatRoomId") String chatRoomId);

    /**
     * 禁言用户
      * @param param
     * @return
     */
    @PostMapping("/admin/block")
    ResponseEntity<Boolean> blockChatRoomUser(@RequestBody ChatRoomOperationParam param);

    /**
     * 解除禁言
     * @param param
     * @return
     */
    @PostMapping("/admin/unblock")
    ResponseEntity<Boolean> unBlockChatRoomUser(@RequestBody ChatRoomOperationParam param);

    /**
     * 批量发送消息
     * @param batchMessageParam
     * @return
     */
    @PostMapping("/batch/message")
    ResponseEntity<Boolean> sendBatchMessage(@RequestBody BatchMessageParam batchMessageParam);
}
