package com.bxm.localnews.admin.facade;

import com.bxm.localnews.admin.facade.fallback.NewsFallbackFactory;

import com.bxm.localnews.admin.param.MonitorTaskBuildParam;
import com.bxm.localnews.admin.param.OptimizationNoticeParam;
import com.bxm.localnews.admin.param.PublishNewsBuildParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-news", fallbackFactory = NewsFallbackFactory.class)

public interface NewsFeignService {

    @PostMapping("facade/news/reply/quartz/scanning")
    void updateNewsReplyStatus();

    @PostMapping("facade/news/sync")
    void syncUser();

    @PostMapping("facade/news/delReply")
    void delReply(@RequestParam(value = "replyId") Long replyId,
                  @RequestParam(value = "userId")Long userId,
                  @RequestParam(value = "newsId")Long  newsId);

    @PostMapping("facade/forumPost/transcodePostVideo")
    void transcodePostVideo(@RequestParam(value = "postId") Long postId);

    @PostMapping("facade/news/addMonitor")
    void addMonitor(@RequestBody MonitorTaskBuildParam param);

    @PostMapping("facade/news/removeMonitor")
    void removeMonitor(@RequestParam("indexId") Long indexId);

    @PostMapping("facade/news/addPublish")
    void addPublish(@RequestBody PublishNewsBuildParam param);

    @PostMapping("facade/news/addOptimizationNotice")
    void addOptimizationNotice(@RequestBody OptimizationNoticeParam param);

    @PostMapping("facade/news/removeOptimizationNotice")
    void removeOptimizationNotice(@RequestParam("id") Long id);

}
