package com.bxm.localnews.admin.facade;

import com.bxm.localnews.admin.facade.fallback.NewsRecommendFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-recommend", fallbackFactory = NewsRecommendFallbackFactory.class)
public interface NewsRecommendFeignService {
    /**
     * 在用户删除时将其置顶的帖子删除
     * @param userId
     * @param postId
     * @return
     */
    @DeleteMapping(value = "api/forum/userTop/cache")
    ResponseEntity cleanUserTop(@RequestParam("userId") Long userId, @RequestParam("postId") Long postId);
}
