package com.bxm.localnews.admin.facade;

import com.bxm.localnews.admin.facade.fallback.PushMsgFallbackFactory;
import com.bxm.localnews.admin.param.PushMsgBuildParam;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-msg", fallbackFactory = PushMsgFallbackFactory.class)
public interface PushMsgFeignService {

    @PostMapping("/push")
    void pushMsg(@RequestBody PushMessage message);

    /**
     * 1-2-3 定时推送消息
     *
     * @param param
     * @return
     */
    @PostMapping("/push/timingPush")
    void timingPush(@RequestBody PushMsgBuildParam param);

    /**
     * 1-2-4 移除定时推送消息
     *
     * @param messageId
     * @return
     */
    @PostMapping("/push/removeTimingPush")
    void removeTimingPush(@RequestParam("messageId") Long messageId);

}
