package com.bxm.localnews.admin.facade;


import com.bxm.localnews.admin.facade.fallback.UserAuthFallbackFactory;
import com.bxm.localnews.admin.param.RemoveAuthCodeParam;
import com.bxm.localnews.admin.param.security.UserAuthCodeParam;
import com.bxm.localnews.admin.param.security.UserRoleParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-user", fallbackFactory = UserAuthFallbackFactory.class,primary = false)
@RequestMapping("facade/user/auth/code")
public interface UserAuthCodeService {

    @ApiOperation(value = "9-99-01 设置用户角色")
    @PostMapping("/add/role")
    ResponseEntity<Boolean> addRole(@RequestBody UserRoleParam param);

    @ApiOperation(value = "9-99-02 移除用户角色")
    @PostMapping("/remove/role")
    ResponseEntity<Boolean> removeRole(@RequestBody UserRoleParam param);

    @ApiOperation(value = "9-99-3 添加用户权限")
    @PostMapping("/add/auth")
    ResponseEntity<Boolean> addAuth(@RequestBody UserAuthCodeParam authCodeParam);

    @ApiOperation(value = "9-99-5 移除用户权限")
    @PostMapping("/del/auth")
    ResponseEntity<Boolean> delAuth(@RequestBody UserAuthCodeParam authCodeParam);

    @ApiOperation(value = "9-99-5 移除用户权限")
    @PostMapping("/add/remove/auth/task")
    ResponseEntity<Boolean> addRemoveAuthTask(@RequestBody RemoveAuthCodeParam RemoveAuthCodeParam);

    @ApiOperation(value = "9-99-5 移除用户权限")
    @PostMapping("/remove/auth/task")
    ResponseEntity<Boolean> removeAuthTask(@RequestParam("userId") Long userId);
}
