package com.bxm.localnews.admin.facade.fallback;

import com.bxm.localnews.admin.dto.EquipmentDTO;
import com.bxm.localnews.admin.facade.BizFeignService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class BizFallbackFactory implements FallbackFactory<BizFeignService> {

    @Override
    public BizFeignService create(Throwable throwable) {
        return id -> {
            log.error(throwable.getMessage(),throwable);
            return ResponseEntity.ok(new EquipmentDTO());
        };
    }
}

