package com.bxm.localnews.admin.facade.fallback;

import com.bxm.localnews.admin.dto.im.BlockUserDTO;
import com.bxm.localnews.admin.facade.IMFacadeService;
import com.bxm.localnews.admin.param.BatchMessageParam;
import com.bxm.localnews.admin.param.ChatRoomOperationParam;
import com.bxm.localnews.admin.param.CreateRedPacketTaskFacadeParam;
import com.bxm.localnews.admin.param.RemoveRedPacketTaskFacadeParam;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Slf4j
public class IMFallbackFactory implements FallbackFactory<IMFacadeService> {

    @Override
    public IMFacadeService create(Throwable throwable) {
        return new IMFacadeService() {
            @Override
            public ResponseEntity<Boolean> block(Long userId, int minutes) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<Boolean> unblock(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<String> token(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().body(null);
            }

            @Override
            public ResponseEntity<Boolean> createChatRoom(String areaCode, Long assistantUserId, String areaName) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().body(false);
            }

            @Override
            public ResponseEntity<Boolean> createRedPacketTask(CreateRedPacketTaskFacadeParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().body(false);
            }

            @Override
            public ResponseEntity<Boolean> removeRedPacketTask(RemoveRedPacketTaskFacadeParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().body(false);
            }

            @Override
            public ResponseEntity<List<BlockUserDTO>> queryChatRoomBlockUser(String chatRoomId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> blockChatRoomUser(ChatRoomOperationParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();            }

            @Override
            public ResponseEntity<Boolean> unBlockChatRoomUser(ChatRoomOperationParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> sendBatchMessage(BatchMessageParam batchMessageParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }
        };
    }
}

