package com.bxm.localnews.admin.facade.fallback;

import com.bxm.localnews.admin.dto.NewsCompleTaskDTO;
import com.bxm.localnews.admin.facade.MissionFeignService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class MissionFallbackFactory implements FallbackFactory<MissionFeignService> {

    @Override
    public MissionFeignService create(Throwable throwable) {
        return (userId, taskName, relationid) -> {
            log.error(throwable.getMessage(), throwable);
            return ResponseEntity.ok(new NewsCompleTaskDTO());
        };
    }
}
