package com.bxm.localnews.admin.facade.fallback;

import com.bxm.localnews.admin.facade.NewsFeignService;

import com.bxm.localnews.admin.param.MonitorTaskBuildParam;
import com.bxm.localnews.admin.param.OptimizationNoticeParam;
import com.bxm.localnews.admin.param.PublishNewsBuildParam;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class NewsFallbackFactory implements FallbackFactory<NewsFeignService> {

    @Override
    public NewsFeignService create(Throwable throwable) {

        return new NewsFeignService() {
            @Override
            public void updateNewsReplyStatus() {
                //记录请求参数
                log.error("updateNewsReplyStatus");
                //记录错误消息
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void syncUser() {
                //记录请求参数
                log.error("syncUser");
                //记录错误消息
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void delReply(Long replyId, Long userId, Long newsId) {
                //记录请求参数
                log.error("replyId:[{}],userId:[{}],newsId:[[]]", replyId, userId, newsId);
                //记录错误消息
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void transcodePostVideo(Long postId) {
                log.error("transcodePostVideo error, postId:[{}]", postId);
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void addMonitor(MonitorTaskBuildParam param) {
                //记录错误消息
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void removeMonitor(Long indexId) {
                //记录错误消息
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void addPublish(PublishNewsBuildParam param) {
                //记录错误消息
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void addOptimizationNotice(OptimizationNoticeParam param) {
                //记录错误消息
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void removeOptimizationNotice(Long id) {
                //记录错误消息
                log.error(throwable.getMessage(), throwable);
            }

        };
    }
}
