package com.bxm.localnews.admin.facade.fallback;

import com.bxm.localnews.admin.facade.PushMsgFeignService;
import com.bxm.localnews.admin.param.PushMsgBuildParam;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class PushMsgFallbackFactory implements FallbackFactory<PushMsgFeignService> {

    @Override
    public PushMsgFeignService create(Throwable throwable) {
        return new PushMsgFeignService() {

            @Override
            public void pushMsg(PushMessage message) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void timingPush(PushMsgBuildParam param) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void removeTimingPush(Long messageId) {
                log.error(throwable.getMessage(), throwable);
            }
        };
    }

}

