package com.bxm.localnews.admin.facade.fallback;

import com.bxm.localnews.admin.facade.UserAuthCodeService;
import com.bxm.localnews.admin.param.RemoveAuthCodeParam;
import com.bxm.localnews.admin.param.security.UserAuthCodeParam;
import com.bxm.localnews.admin.param.security.UserRoleParam;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class UserAuthFallbackFactory implements FallbackFactory<UserAuthCodeService> {

    @Override
    public UserAuthCodeService create(Throwable throwable) {
        return new UserAuthCodeService() {
            @Override
            public ResponseEntity<Boolean> addRole(UserRoleParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Boolean> removeRole(UserRoleParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Boolean> addAuth(UserAuthCodeParam authCodeParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Boolean> delAuth(UserAuthCodeParam authCodeParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Boolean> addRemoveAuthTask(RemoveAuthCodeParam RemoveAuthCodeParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Boolean> removeAuthTask(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(false);
            }
        };
    }
}
