package com.bxm.localnews.admin.integration;

import com.bxm.localnews.admin.dto.im.BlockUserDTO;
import com.bxm.localnews.admin.facade.IMFacadeService;
import com.bxm.localnews.admin.param.BatchMessageParam;
import com.bxm.localnews.admin.param.ChatRoomOperationParam;
import com.bxm.localnews.admin.param.CreateRedPacketTaskFacadeParam;
import com.bxm.localnews.admin.param.RemoveRedPacketTaskFacadeParam;
import com.bxm.newidea.component.tools.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class IMIntegrationService {
    private IMFacadeService imFacadeService;

    @Autowired
    public IMIntegrationService(IMFacadeService imFacadeService) {
        this.imFacadeService = imFacadeService;
    }

    /**
     * 封禁用户即时通讯能力
     * @param userId  屏蔽的用户ID
     * @param endTime 屏蔽截止时间
     * @return true表示操作成功
     */
    public Boolean block(Long userId, Date endTime) {
        Long mintues = DateUtils.getDiffMinutes(new Date(), endTime, true);
        return imFacadeService.block(userId, mintues.intValue()).getBody();
    }

    public Boolean unblock(Long userId) {
        return imFacadeService.unblock(userId).getBody();
    }

    /**
     * 创建聊天室
     * @param areaCode
     * @return
     */
    public Boolean createChatRoom(String areaCode,Long assistantUserId,String areaName) {

        return imFacadeService.createChatRoom(areaCode,assistantUserId,areaName).getBody();
    }

    /**
     * 创建定时红包的任务
     * @param param
     * @return
     */
    public Boolean createRedPacketTask(CreateRedPacketTaskFacadeParam param) {
        return imFacadeService.createRedPacketTask(param).getBody();
    }

    /**
     * 创建定时红包的任务
     * @param param
     * @return
     */
    public Boolean removeRedPacketTask(RemoveRedPacketTaskFacadeParam param) {
        return imFacadeService.removeRedPacketTask(param).getBody();
    }

    public String token(Long userId) {
        ResponseEntity<String> response = imFacadeService.token(userId);
        if (response.getBody() == null) {
            return null;
        }

        return response.getBody();
    }

	public List<BlockUserDTO> queryChatRoomBlockUser(String chatRoomId) {
        ResponseEntity<List<BlockUserDTO>> response =  imFacadeService.queryChatRoomBlockUser(chatRoomId);
        if (response.getBody() == null) {
            return null;
        }
        return response.getBody();
	}

    public boolean blockChatRoomUser(ChatRoomOperationParam param) {
        ResponseEntity<Boolean> response = imFacadeService.blockChatRoomUser(param);
        if (response.getBody() == null) {
            return false;
        }
        return response.getBody();
    }

    public Boolean unBlockChatRoomUser(ChatRoomOperationParam param) {

        ResponseEntity<Boolean> response = imFacadeService.unBlockChatRoomUser(param);
        if (response.getBody() == null) {
            return false;
        }
        return response.getBody();
    }

    public Boolean sendBatchMessage(BatchMessageParam batchMessageParam) {
        ResponseEntity<Boolean> response = imFacadeService.sendBatchMessage(batchMessageParam);
        if (response.getBody() == null) {
            return false;
        }
        return response.getBody();
    }
}
