package com.bxm.localnews.admin.integration;

import com.bxm.localnews.admin.dto.NewsDTO;
import com.bxm.localnews.admin.dto.NewsDetailDTO;
import com.bxm.localnews.admin.param.AdminNewsPageParam;
import com.bxm.localnews.admin.service.NewsElasticService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class NewsElasticIntegrationService {

    private final NewsElasticService newsElasticService;

    @Autowired
    public NewsElasticIntegrationService(NewsElasticService newsElasticService) {
        this.newsElasticService = newsElasticService;
    }

    public NewsDetailDTO getNewsFromES(Long id) {
        ResponseEntity<List<NewsDetailDTO>> result = newsElasticService.multipleGet(new Long[]{id});
        if (null != result) {
            if (!result.getStatusCode().isError() && result.getBody() != null && !result.getBody().isEmpty()) {
                return result.getBody().get(0);
            }
        }
        return null;
    }

    public NewsDTO listNews(AdminNewsPageParam adminNewsPageParam) {
        ResponseEntity<NewsDTO> result = newsElasticService.listNews(adminNewsPageParam);
        if (null != result) {
            if (!result.getStatusCode().isError() && result.getBody() != null) {
                return result.getBody();
            }
        }
        return null;
    }

}
