package com.bxm.localnews.admin.integration;

import com.bxm.localnews.admin.facade.NewsFeignService;

import com.bxm.localnews.admin.param.MonitorTaskBuildParam;
import com.bxm.localnews.admin.param.OptimizationNoticeParam;
import com.bxm.localnews.admin.param.PublishNewsBuildParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class NewsIntegrationService {
    private final NewsFeignService newsFeignService;

    @Autowired
    public NewsIntegrationService(NewsFeignService newsFeignService) {
        this.newsFeignService = newsFeignService;
    }

    public void updateNewsReplyStatus() {
        newsFeignService.updateNewsReplyStatus();
    }

    public void syncUser() {
        newsFeignService.syncUser();
    }

    public void delReply(Long replyId, Long userId, Long newsId) {
        newsFeignService.delReply(replyId, userId, newsId);
    }

    public void transcodePostVideo(Long postId) {
        newsFeignService.transcodePostVideo(postId);
    }

    public void addMonitor(MonitorTaskBuildParam param) {
        newsFeignService.addMonitor(param);
    }

    public void removeMonitor(Long indexId) {
        newsFeignService.removeMonitor(indexId);
    }

    public void addPublish(PublishNewsBuildParam param) {
        newsFeignService.addPublish(param);
    }

    public void addOptimizationNotice(OptimizationNoticeParam param) {
        newsFeignService.addOptimizationNotice(param);
    }

    public void removeOptimizationNotice(Long id) {
        newsFeignService.removeOptimizationNotice(id);
    }

}
