package com.bxm.localnews.admin.integration;

import com.bxm.localnews.admin.facade.PushMsgFeignService;
import com.bxm.localnews.admin.param.PushMsgBuildParam;
import com.bxm.localnews.admin.vo.ForumPost;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class PushMsgIntegService extends BaseService {

    @Resource
    private PushMsgFeignService pushMsgFeignService;

    public void pushMsg(PushMessage message) {
        pushMsgFeignService.pushMsg(message);
    }

    public void timingPush(PushMsgBuildParam param) {
        pushMsgFeignService.timingPush(param);
    }

    public void removeTimingPush(Long messageId) {
        pushMsgFeignService.removeTimingPush(messageId);
    }

    /**
     * 推送消息
     *
     * @param forumPost        修改后帖子
     * @param existedForumPost 修改前帖子
     * @param forumTitle       帖子标题
     */
    public void pushMsg(ForumPost forumPost, ForumPost existedForumPost, String forumTitle, String h5ServerHost) {
        //精华帖推送
        if (existedForumPost.getIsBrilliant() != null && existedForumPost.getIsBrilliant() == 0
                && forumPost.getIsBrilliant() != null && forumPost.getIsBrilliant() == 1) {
            String content = "恭喜！你发布的【" + forumTitle + "】被加精，奖励你40朵小红花，你的内容将会被更多人看到哦~";
            PushMessage message = getPushMessage(PushMessageEnum.ESSENCE_POST, forumPost, content, h5ServerHost);
            this.pushMsg(message);
        }

        //现金帖推送
        if (existedForumPost.getIsCash() != null && existedForumPost.getIsCash() == 0
                && forumPost.getIsCash() != null && forumPost.getIsCash() == 1) {
            String content = "速来领钱！你发布的【" + forumTitle + "】获得了现金奖励，请快快联系我们领取！";
            PushMessage message = getPushMessage(PushMessageEnum.CASH_POST, forumPost, content, h5ServerHost);
            this.pushMsg(message);
        }

        //爆料贴推送
        if (existedForumPost.getIsBroke() != null && existedForumPost.getIsBroke() == 0
                && forumPost.getIsBroke() != null && forumPost.getIsBroke() == 1) {
            String content = "恭喜！你发布的【" + forumTitle + "】被选为爆料内容，奖励你50朵小红花。";
            PushMessage message = getPushMessage(PushMessageEnum.BROKE_POST, forumPost, content, h5ServerHost);
            this.pushMsg(message);
        }
    }

    /**
     * 获得帖子推送对象
     *
     * @param pushMessageEnum 消息推送枚举
     * @param forumPost       帖子
     * @param content         内容
     * @return 推送对象
     */
    private PushMessage getPushMessage(PushMessageEnum pushMessageEnum, ForumPost forumPost, String content, String h5ServerHost) {
        PushPayloadInfo info = PushPayloadInfo.build(pushMessageEnum);
        Long msgId = nextId();
        info.setMsgId(msgId);
        info.addExtend("msgId", msgId);
        info.addExtend("url", h5ServerHost + "/servicePrize.html?areaCode=" + forumPost.getAreaCode());
        info.addExtend("postId", forumPost.getId());
        PushMessage message = PushMessage.build();
        message.setTitle("");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(forumPost.getUserId()));
        message.setPayloadInfo(info);
        return message;
    }

}
