package com.bxm.localnews.admin.integration;

import com.bxm.localnews.admin.facade.UserAccountFeignService;
import com.bxm.localnews.admin.param.AccountGoldParam;
import com.bxm.localnews.admin.vo.ForumPost;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class UserAccountIntegrationService {

    @Resource
    private UserAccountFeignService userAccountFeignService;

    public Boolean addGold(AccountGoldParam param) {
        return userAccountFeignService.addGold(param).getBody();
    }

    public Integer countGoldByPostId(Long postId, Long userId) {
        return userAccountFeignService.countGoldByPostId(postId, userId).getBody();
    }

    /**
     * 帖子被选为精华或爆料时,给用户增加小红花
     *
     * @param forumPost        修改后帖子
     * @param existedForumPost 修改前帖子
     */
    public void addUserGold(ForumPost forumPost, ForumPost existedForumPost, String forumTitle) {
        String content;
        //帖子加精
        if (existedForumPost.getIsBrilliant() != null && existedForumPost.getIsBrilliant() == 0
                && forumPost.getIsBrilliant() != null && forumPost.getIsBrilliant() == 1) {
            AccountGoldParam param = new AccountGoldParam();
            param.setUserId(forumPost.getUserId());
            param.setGold(40);
            param.setGoldType("USABLE_GOLD");
            param.setGoldFlowType("BRILLIANT_POST_AWARD");
            param.setAddTotal(true);
            param.setRelationId(forumPost.getId());
            content = "你发布的【" + forumTitle + "】被加精";
            param.setContent(content);
            this.addGold(param);
        }
        //爆料贴
        if (existedForumPost.getIsBroke() != null && existedForumPost.getIsBroke() == 0
                && forumPost.getIsBroke() != null && forumPost.getIsBroke() == 1) {
            AccountGoldParam param = new AccountGoldParam();
            param.setUserId(forumPost.getUserId());
            param.setGold(50);
            param.setGoldType("USABLE_GOLD");
            param.setGoldFlowType("BROKE_POST");
            param.setAddTotal(true);
            param.setRelationId(forumPost.getId());
            content = "你发布的【" + forumTitle + "】被选为爆料";
            param.setContent(content);
            this.addGold(param);
        }
    }

    /**
     * 删除帖子时，扣除用户金币
     *
     * @param forumId 帖子id
     * @param userId  用户id
     */
    public void deductUserGold(Long forumId, Long userId) {
        Integer goldNum = this.countGoldByPostId(forumId, userId);
        if (null != goldNum && goldNum > 0) {
            AccountGoldParam param = new AccountGoldParam();
            param.setUserId(userId);
            param.setGold(-goldNum);
            param.setGoldType("USABLE_GOLD");
            param.setGoldFlowType("TASK_POST_DELETE");
            param.setAddTotal(false);
            param.setRelationId(forumId);
            this.addGold(param);
        }
    }

}
