package com.bxm.localnews.admin.integration;

import com.bxm.localnews.admin.facade.UserAuthCodeService;
import com.bxm.localnews.admin.param.RemoveAuthCodeParam;
import com.bxm.localnews.admin.param.security.UserAuthCodeParam;
import com.bxm.localnews.admin.param.security.UserRoleParam;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class UserAuthCodeIntegrationService {

    @Resource
    private UserAuthCodeService userAuthCodeService;

    public Boolean addRole(UserRoleParam param) {
        ResponseEntity<Boolean> responseEntity = userAuthCodeService.addRole(param);
        return responseEntity.getBody();
    }

    public Boolean removeRole(UserRoleParam param) {
        ResponseEntity<Boolean> responseEntity = userAuthCodeService.removeRole(param);
        return responseEntity.getBody();
    }

    public Boolean addAuth(UserAuthCodeParam param) {
        ResponseEntity<Boolean> responseEntity = userAuthCodeService.addAuth(param);
        return responseEntity.getBody();
    }

    public Boolean delAuth(UserAuthCodeParam param) {
        ResponseEntity<Boolean> responseEntity = userAuthCodeService.delAuth(param);
        return responseEntity.getBody();
    }

    public Boolean removeAuthTask(Long userId) {
        ResponseEntity<Boolean> responseEntity = userAuthCodeService.removeAuthTask(userId);
        return responseEntity.getBody();
    }
    public Boolean addRemoveAuthTask(RemoveAuthCodeParam param) {
        ResponseEntity<Boolean> responseEntity = userAuthCodeService.addRemoveAuthTask(param);
        return responseEntity.getBody();
    }
}
