package com.bxm.localnews.admin.param;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@ApiModel(description = "增加帖子点击数任务参数构建")
@Data
public class AddPostClickCountParam extends BaseBean {

    @ApiModelProperty("帖子id")
    private Long postId;

    @ApiModelProperty("增加的点击数")
    private Long clickCount;

    private Long addedClickCount = 0L;

    private Date endTime;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date startTime;

}
