package com.bxm.localnews.admin.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("新闻查询实体")
@Data
public class AdminNewsPageParam extends PageParam {

    @ApiModelProperty("新闻id")
    private Long id;

    @ApiModelProperty("新闻标题")
    private String keyword;

    @ApiModelProperty("新闻内容")
    private String content;

    @ApiModelProperty("区域信息")
    private String areaCode;

    @ApiModelProperty("标签")
    private Integer showLevel;

    @ApiModelProperty("状态")
    private Integer status;

    @ApiModelProperty("频道编号")
    private Integer kindId;

    @ApiModelProperty("审核状态")
    private Integer reviewStatus;

    @ApiModelProperty("推荐状态 是否推荐 0:否  1是")
    private Byte isRecommend;

    @ApiModelProperty("发布区域类型0全国 1地方")
    private Integer deliveryType;

    @ApiModelProperty("新闻来源")
    private String author;

}
