package com.bxm.localnews.admin.service;

import com.bxm.localnews.admin.dto.NewsDTO;
import com.bxm.localnews.admin.dto.NewsDetailDTO;
import com.bxm.localnews.admin.param.AdminNewsPageParam;
import com.bxm.localnews.admin.param.NewsParam;
import com.bxm.localnews.admin.service.fallback.NewsSearchFallbackFactroy;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "localnews-search", fallbackFactory = NewsSearchFallbackFactroy.class)
public interface NewsElasticService{
     @PostMapping(value = "api/news/search/sync")
     ResponseEntity save(@RequestBody NewsParam newsParam);

     @GetMapping(value = "api/news/search/get")
     ResponseEntity<List<NewsDetailDTO>> multipleGet(@RequestParam("ids") Long[] ids);

     @PostMapping(value = "api/news/search")
     ResponseEntity<NewsDTO> listNews(@RequestBody AdminNewsPageParam adminNewsPageParam);

}
