package com.bxm.localnews.admin.service;

import com.bxm.localnews.admin.param.Keyword;
import com.bxm.localnews.admin.service.fallback.NewsSyncFallbackFactory;
import com.bxm.localnews.admin.vo.News;
import com.bxm.localnews.admin.vo.PendingContent;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(value = "localnews-spider-sync", fallbackFactory = NewsSyncFallbackFactory.class)
public interface NewsSyncService {

     @PostMapping(value = "api/news/manage/save")
     ResponseEntity save(@RequestBody News news);

     @PostMapping(value = "api/post/tag/list")
     ResponseEntity<List<Keyword>> analysisContent(@RequestBody PendingContent pendingContent);

     @PostMapping(value = "api/news/status/update")
     ResponseEntity updateStatus(@RequestBody News news);
}
