package com.bxm.localnews.admin.service;

import com.bxm.localnews.admin.dto.AccountQueryDto;
import com.bxm.localnews.admin.dto.ContentDTO;
import com.bxm.localnews.admin.param.AccountAddParam;
import com.bxm.localnews.admin.param.AccountQueryParam;
import com.bxm.localnews.admin.param.CrawlingParam;
import com.bxm.localnews.admin.service.fallback.SpiderManageFallbackFactory;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@FeignClient(value = "manager-service", fallbackFactory = SpiderManageFallbackFactory.class)
public interface SpiderManageService {

    @PostMapping("/spider/pageDownload")
    ResponseEntity<ContentDTO> pageDownload(@RequestBody CrawlingParam crawlingParam);

    /**
     * 添加一个微信公众号到待爬取的公众号列表
     */
    @RequestMapping(value = "/wechat/account", method = RequestMethod.POST)
    ResponseEntity<Message> addAccountByName(@RequestBody AccountAddParam addAccountParam);

    /**
     * 分页查询公众号列表
     */
    @GetMapping("/wechat/account")
    ResponseEntity<PageWarper<AccountQueryDto>> queryAccountByName(@RequestParam("account") String account,
                                                                   @RequestParam("regionCode") String regionCode,
                                                                   @RequestParam("pageNum") Integer pageNum,
                                                                   @RequestParam("pageSize") Integer pageSize);

    /**
     * 删除公众号
     */
    @PostMapping("/wechat/deleteAccount")
    ResponseEntity<Boolean> deleteById(@RequestParam("id") Long id);
}
