package com.bxm.localnews.admin.service.fallback;

import com.bxm.localnews.admin.param.Keyword;
import com.bxm.localnews.admin.service.NewsSyncService;
import com.bxm.localnews.admin.vo.News;
import com.bxm.localnews.admin.vo.PendingContent;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class NewsSyncFallbackFactory implements FallbackFactory<NewsSyncService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsSearchFallbackFactroy.class);

    @Override
    public NewsSyncService create(Throwable throwable) {
        return new NewsSyncService() {
            @Override
            public ResponseEntity save(News news) {
                LOGGER.error(throwable.getMessage(), throwable);
                return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).build();
            }

            @Override
            public ResponseEntity<List<Keyword>> analysisContent(PendingContent pendingContent) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity updateStatus(News news) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }
        };
    }
}