package com.bxm.localnews.admin.service.fallback;

import com.bxm.localnews.admin.dto.AccountQueryDto;
import com.bxm.localnews.admin.dto.ContentDTO;
import com.bxm.localnews.admin.param.AccountAddParam;
import com.bxm.localnews.admin.param.AccountQueryParam;
import com.bxm.localnews.admin.param.CrawlingParam;
import com.bxm.localnews.admin.service.SpiderManageService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class SpiderManageFallbackFactory implements FallbackFactory<SpiderManageService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzIntegrationFallbackFactory.class);

    @Override
    public SpiderManageService create(Throwable throwable) {
        return new SpiderManageService(){
            @Override
            public ResponseEntity<ContentDTO> pageDownload(CrawlingParam crawlingParam) {
                LOGGER.error(crawlingParam.toString());
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<Message> addAccountByName(AccountAddParam addAccountParam) {
                LOGGER.error(addAccountParam.toString());
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<PageWarper<AccountQueryDto>> queryAccountByName(String account, String regionCode, Integer pageNum, Integer pageSize) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }
            @Override
            public ResponseEntity<Boolean> deleteById(Long id) {
                LOGGER.error(id.toString());
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }
        };
    }
}
