package com.bxm.localnews.admin.facade.fallback;

import com.bxm.localnews.admin.dto.ActiveCodeDTO;
import com.bxm.localnews.admin.dto.ImportResultDTO;
import com.bxm.localnews.admin.facade.UserVipFeignService;
import com.bxm.localnews.admin.param.AddTimesParam;
import com.bxm.localnews.admin.param.OfflineBindRelationParam;
import com.bxm.newidea.component.vo.Message;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author liujia
 * @date 2020/6/3 20:25
 **/
@Component
@Slf4j
public class UserVipFallbackFactory implements FallbackFactory<UserVipFeignService> {
    @Override
    public UserVipFeignService create(Throwable cause) {
        return new UserVipFeignService() {

            @Override
            public ResponseEntity<ImportResultDTO> manualActiveVip(String phoneNo) {
                log.error(cause.getMessage(), cause);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<List<ActiveCodeDTO>> batchExport(String areaCode, Integer limit) {
                log.error(cause.getMessage(), cause);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<List<ImportResultDTO>> batchBind(List<OfflineBindRelationParam> params) {
                log.error(cause.getMessage(), cause);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Message> addNum(AddTimesParam param) {
                log.error(cause.getMessage(), cause);
                return ResponseEntity.ok(Message.build(false, "调用用户服务失败"));
            }
        };
    }
}
