package com.bxm.localnews.admin.integration;

import com.bxm.localnews.admin.dto.ActiveCodeDTO;
import com.bxm.localnews.admin.dto.ImportResultDTO;
import com.bxm.localnews.admin.facade.UserVipFeignService;
import com.bxm.localnews.admin.param.AddTimesParam;
import com.bxm.localnews.admin.param.OfflineBindRelationParam;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author liujia
 * @date 2020/6/3 20:28
 **/
@Component
public class UserVipIntegrationService {

    @Autowired
    private UserVipFeignService userVipFeignService;

    public ImportResultDTO manualActiveVip(String phoneNo) {
        if (null == phoneNo) {
            return null;
        }

        ResponseEntity<ImportResultDTO> responseEntity = userVipFeignService.manualActiveVip(phoneNo);

        if (responseEntity.hasBody()) {
            return responseEntity.getBody();
        }
        return null;
    }

    public List<ActiveCodeDTO> batchExport(String areaCode, Integer limit) {
        ResponseEntity<List<ActiveCodeDTO>> responseEntity = userVipFeignService.batchExport(areaCode, limit);
        if (responseEntity.hasBody()) {
            return responseEntity.getBody();
        }

        return Lists.newArrayList();
    }

    public List<ImportResultDTO> batchBind(List<OfflineBindRelationParam> params) {
        ResponseEntity<List<ImportResultDTO>> responseEntity = userVipFeignService.batchBind(params);
        if (responseEntity.hasBody()) {
            return responseEntity.getBody();
        }

        return Lists.newArrayList();
    }

    public Message addNum(AddTimesParam param) {
        ResponseEntity<Message> responseEntity = userVipFeignService.addNum(param);
        if (responseEntity.hasBody()) {
            return responseEntity.getBody();
        }

        return Message.build(false, "调用用户服务失败");
    }
}
