package com.bxm.localnews.admin.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.facade.WithdrawFeignService;
import com.bxm.localnews.admin.vo.WithdrawFlow;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.alibaba.fastjson.JSON.toJSONString;

/**
 * @author zhaoyadong 2019/3/12 21:40
 * @desc
 */
@Slf4j
@Service
public class WithdrawIntegrationService {

    @Autowired
    private WithdrawFeignService withdrawFeignService;

    public void userWithdraw(WithdrawFlow withdrawFlow) {
        if (log.isDebugEnabled()) {
            log.debug("发起提现: {}", toJSONString(withdrawFlow));
        }
        try {
            withdrawFeignService.withdraw(withdrawFlow);
        } catch(Exception e) {
            log.error("请求提现接口失败", e);
        }

    }
}
