package com.bxm.localnews.admin.dto;

import com.bxm.localnews.admin.vo.AdminRole;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel("用户信息")
public class CurrentUserVo {

    @ApiModelProperty("角色列表")
    private List<AdminRole> roles;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("用户昵称")
    private String username;

    @ApiModelProperty("手机号")
    private String phone;

    public CurrentUserVo() {
    }

    public CurrentUserVo(List<AdminRole> roles, Long userId, String username, String phone) {
        this.roles = roles;
        this.userId = userId;
        this.username = username;
        this.phone = phone;
    }

    public List<AdminRole> getRoles() {
        return roles;
    }

    public void setRoles(List<AdminRole> roles) {
        this.roles = roles;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

}
