package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.vo.BaseBean;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

public class CommodityCodeBean extends BaseBean {

    private static final long serialVersionUID = 1L;

    private Long id;

    private String code;

    private Long commodityId;

    private int usedFlag = 0;

    private Long privilegeId;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date expireTime;

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public Long getCommodityId() {
        return commodityId;
    }

    public void setCommodityId(Long commodityId) {
        this.commodityId = commodityId;
    }

    public int getUsedFlag() {
        return usedFlag;
    }

    public void setUsedFlag(int usedFlag) {
        this.usedFlag = usedFlag;
    }

    public Long getPrivilegeId() {
        return privilegeId;
    }

    public void setPrivilegeId(Long privilegeId) {
        this.privilegeId = privilegeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CommodityCodeBean that = (CommodityCodeBean) o;
        return
                Objects.equals(code, that.code) &&
                Objects.equals(commodityId, that.commodityId) ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), id, code, commodityId, usedFlag, privilegeId, expireTime);
    }
}